'
'  This program writes a data byte to the specified UART register.  The
' DOS command-line syntax is
'
'  UARTW port register data
'
' where port is the hex base address of the COM port, register is the
' register number to write to (0 - 7), and data is the (decimal) byte to
' write to the port.  Actually, although the primary purpose of UARTW is
' to access COM ports, it can be used to write to any computer port.  For
' this more general usage, just specify the port address and 0 for the
' register.  (Similarly, you can access UART registers in this manner by
' adding the 0-based register number to the port address yourself before
' using UARTW.)
'
'  (UARTW isn't particularly useful as a replacement for programs designed
' to dynamically output data to peripheral devices.)
'
'  Get command-line arguments.  If incomplete, display message giving
' usage syntax.
'
CALL PARSE(COMMAND$," ",P$,R1$)
CALL PARSE(R1$," ",R$,V$)
V$=LTRIM$(V$) : R$=RTRIM$(R$) : P$=UCASE$(RTRIM$(P$)) : VL=VAL(V$)
IF V$<>"" THEN
'
'  Convert UART register, which is really just a relative port address,
' to an absolute port address and write data byte.
'
PORT=VAL("&H"+P$)+VAL("&H"+R$)
OUT PORT,VL
ELSE
PRINT
PRINT "USAGE SYNTAX:"
PRINT
PRINT "UARTW hex_base_address register data_byte"
END IF
END
'
'  This subroutine parses the string S$ into parts S1$ and S2$ based on
' the delimiting string DL$.
'
SUB PARSE(S$,DL$,S1$,S2$)
SI$=LTRIM$(RTRIM$(S$))
N=LEN(SI$)
S1$=SI$
S2$=""
IF N=0 THEN GOTO TERM
I=INSTR(SI$,DL$)
IF I=0 THEN GOTO TERM
S1$=MID$(SI$,1,I-1)
S2$=MID$(SI$,I+LEN(DL$),N-I-LEN(DL$)+1)
TERM:
END SUB
